/*****************************************************************************/
/*                                Includes
/*****************************************************************************/

#include "TimeTracking.h" 
  
/*****************************************************************************/
/*                          Typedefs and Structs
/*****************************************************************************/

enum{ 
  SELECT,
  UNSELECT
};

/*****************************************************************************/
/*                           Time Tracking Main Menu
/*****************************************************************************/

void vfnTimeTrackingMenu(void){

  UINT8 u8TimeTrackingIndex=0;                                                     
  
  gu8ButtonStatus=BUTTON_IDDLE;
  
  /* Print Backrgound Image */
  vfnPrint_SD_Image("TMRMENU.AMI",0,0);
    
  /* Periodical Main Task until Exit */
  while(gu8ButtonStatus!=BUTTON_EXIT){
  
    TSS_Task(); // Touch Sensing Periodical Task
  
    /* Check Buttons Status */
    switch(gu8ButtonStatus){
    
      /* SWITCH SELECTED OPTION */
      case BUTTON_LEFT:
        u8TimeTrackingIndex=~u8TimeTrackingIndex;
      break;
    
      /* SWITCH SELECTED OPTION */
      case BUTTON_RIGHT:
        u8TimeTrackingIndex=~u8TimeTrackingIndex;
      break;
    
      /* SELECT APPLICATION */
      case BUTTON_SELECT:    
        if(!u8TimeTrackingIndex)
          vfnTimerRoutine(); // Start Timer Routine
    
        if(u8TimeTrackingIndex)
          vfnChronometerRoutine(); // Start Chronometer Routine
    
        /* Comming Back from Application actions */
        gu8ButtonStatus=BUTTON_IDDLE;
        u16ExitCounter =0;
        /* Print Backrgound Image */
        vfnPrint_SD_Image("TMRMENU.AMI",0,0);
        u8TimeTrackingIndex=0;
      break;
      
      default:
      break;
    }
   
    /* PRINT SELECTED */
    if(gu8ButtonStatus!=BUTTON_IDDLE){
   
      /* PRINT SELECTED CHRONOMETER */
      if(u8TimeTrackingIndex)
        vfnPrint_SD_Image("CHRONSEL.AMI",38,0);
    
      /* PRINT SELECTED TIMER */
      if(!u8TimeTrackingIndex)
        vfnPrint_SD_Image("TIMERSEL.AMI",38,0);    
   
    }
   
    /* DEBOUNCE CASE */
    if(gu8ButtonStatus==BUTTON_LEFT | gu8ButtonStatus==BUTTON_RIGHT)
       gu8ButtonStatus=BUTTON_IDDLE;   

  }   

}
 
/*****************************************************************************/
/*                           Chronometer Routine
/*****************************************************************************/

void vfnChronometerRoutine (void){

  UINT8 u8dSeconds=0, u8Seconds=0, u8Minutes=0, u8TimerOnOff=0;
  
  gu8ButtonStatus=BUTTON_IDDLE;
  
  /* PRINT ZEROS */
  Display_Number(u8dSeconds, DSECOND_POSITION, 2); // Print Tenths of a Second
  Display_Number(u8Seconds, SECOND_POSITION, 2);   // Print Seconds
  Display_Number(u8Minutes, MINUTE_POSITION, 2);   // Print Minutes
  
  /* Periodical Chronometer Task until Exit */
  while(gu8ButtonStatus!=BUTTON_EXIT){
  
    TSS_Task();  // Touch Sensing Periodical Task
    
    /* ENTER/SELECT BUTTON */
    if(gu8ButtonStatus == BUTTON_SELECT){
    
      /* Switch chronometer ON/OFF */
      u8TimerOnOff=~u8TimerOnOff;
     
      /* Flag in TIMER2 ON */
      if(u8TimerOnOff)
        TIME_TRACK_ENABLE=ON;      
     
      /* Flag in TIMER2 OFF */
      if(!u8TimerOnOff)
        TIME_TRACK_ENABLE=OFF;     
     
      /* TURN COUNTING ROUTINE FLAG OFF */
      gu8TPM1_CH0_IRQ=0;     
      /* DEBOUNCE */
      gu8ButtonStatus=BUTTON_IDDLE;
      
    }
    
    /* COUNTING ROUTINE 1ms */
    if(gu8TPM1_CH0_IRQ){
    
      /* TURN COUNTING ROUTINE FLAG OFF, LATER TURNED ON IN TIMER2 ISR */
      gu8TPM1_CH0_IRQ=False;
     
      u8dSeconds++;         // Add a Tenth of a Second
          
      /* SECOND HAS ELAPSED */
      if(u8dSeconds>99){
        u8dSeconds=0;
        u8Seconds++;
        
        /* MINUTE HAS ELAPSED */
        if(u8Seconds>59){  
          u8Seconds=0;
          u8Minutes++;
          
          /* MAX MINUTES HAVE ELAPSED */
          if(u8Minutes>99){ 
            u8Minutes=0;
          
          } 
          Display_Number(u8Minutes, MINUTE_POSITION, 2); // PRINT MINUTES
        
        }      
        Display_Number(u8Seconds, SECOND_POSITION, 2);   // PRINT SECONDS
      
      }
      Display_Number(u8dSeconds, DSECOND_POSITION, 2);   // PRINT TENTHS OF A SECOND 
    
    }
    
    /* RESET CHRONOMETER */
    if(!u8TimerOnOff && gu8ButtonStatus == BUTTON_DOWN){
    
      u8dSeconds=0; 
      u8Seconds=0; 
      u8Minutes=0;
     
      /* PRINT ZEROS */
      Display_Number(u8dSeconds, DSECOND_POSITION, 2);  // Print Tenths of a Second
      Display_Number(u8Seconds, SECOND_POSITION, 2);    // Print Seconds
      Display_Number(u8Minutes, MINUTE_POSITION, 2);    // Print Minutes
     
      gu8ButtonStatus=BUTTON_IDDLE;
    }
    
  }
  
} 
 
/*****************************************************************************/
/*                             Timer Routine
/*****************************************************************************/

void vfnTimerRoutine(void){

  UINT8 u8Minutes=0, u8Seconds=0, au8TimeArray[5], u8TimerIndex=1, sinbandera=1;
  
  gu8ButtonStatus=BUTTON_IDDLE;
  vfnClearBuffer(au8TimeArray,5);
  
  /* PRINT ZEROS */
  Display_Number(0x00, DSECOND_POSITION, 2);     // Print Tenths of a Second
  Display_Number(u8Seconds, SECOND_POSITION, 2); // Print Seconds
  Display_Number(u8Minutes, MINUTE_POSITION, 2); // Print Minutes
  vfnUpdate(0,u8TimerIndex,SELECT);
  
  /* Periodical TIMER Task until Exit */
  while (gu8ButtonStatus!=BUTTON_EXIT){
  
    TSS_Task();  // Touch Sensing Periodical Task
    
    /* Setting TIMER */
    switch (gu8ButtonStatus){
    
      /* SWITCH DIGIT */
      case BUTTON_LEFT:
        vfnUpdate(au8TimeArray[u8TimerIndex],u8TimerIndex,UNSELECT);
        u8TimerIndex--;
        if(u8TimerIndex<1)
        u8TimerIndex=4;
        vfnUpdate(au8TimeArray[u8TimerIndex],u8TimerIndex,SELECT);
      break;
    
      /* SWITCH DIGIT */
      case BUTTON_RIGHT:
        vfnUpdate(au8TimeArray[u8TimerIndex],u8TimerIndex,UNSELECT);
        u8TimerIndex++;
        if(u8TimerIndex>4)
        u8TimerIndex=1;
        vfnUpdate(au8TimeArray[u8TimerIndex],u8TimerIndex,SELECT);
      break;
    
      /* INCREMENT DIGIT */
      case BUTTON_UP:
        if(sinbandera==1){
          au8TimeArray[u8TimerIndex]++;
          if(au8TimeArray[u8TimerIndex]>9 || au8TimeArray[3]>5)
            au8TimeArray[u8TimerIndex]=0;
          vfnUpdate(au8TimeArray[u8TimerIndex],u8TimerIndex,SELECT);
          sinbandera=0;
        }
      break;
    
      /* DECREMENT DIGIT */
      case BUTTON_DOWN:
        au8TimeArray[u8TimerIndex]--;
        if(au8TimeArray[3]>9)
          au8TimeArray[3]=5;
        if(au8TimeArray[u8TimerIndex]>9)
          au8TimeArray[u8TimerIndex]=9;
        vfnUpdate(au8TimeArray[u8TimerIndex],u8TimerIndex,SELECT);
      break;
    
      /* START COUNTDOWN */
      case BUTTON_SELECT:
        u8Minutes=(au8TimeArray[1]*10)+au8TimeArray[2];
        u8Seconds=(au8TimeArray[3]*10)+au8TimeArray[4];
        vfnStartCountDown(u8Minutes,u8Seconds);
        /* After count down routine */
        Display_Number(0x00, DSECOND_POSITION, 2);
        Display_Number(u8Seconds, SECOND_POSITION, 2);
        Display_Number(u8Minutes, MINUTE_POSITION, 2);
        vfnUpdate(au8TimeArray[u8TimerIndex],u8TimerIndex,SELECT);
      break;
    
      case BUTTON_IDDLE:
        sinbandera=1;
      break;
    
      default:
      break;
    }
    /* EXIT DEBOUNCE */
    if(gu8ButtonStatus!=BUTTON_UP && gu8ButtonStatus!=BUTTON_EXIT)
      gu8ButtonStatus=BUTTON_IDDLE;
  }

}
 
/*****************************************************************************/
/*                      Draw Numbers Selection Square
/*****************************************************************************/

void vfnDrawSelectedSquare (UINT8 u8Xpos,UINT8 u8Ypos, UINT8 u8Xsize, UINT8 u8Ysize){

  UINT8 u8SquareColorLB, u8SquareColorHB;
  
  /* From 24bits to 16bits Pixel Color */
  u8SquareColorLB=Convert_888_to_565(Green,LOWBYTE);
  u8SquareColorHB=Convert_888_to_565(Green,HIGHBYTE);
  
  /* Color Selection Area */
  colorArea(u8Xpos,u8Xpos,u8Ypos,u8Ypos+u8Ysize-1,u8SquareColorHB,u8SquareColorLB);
  colorArea(u8Xpos+u8Xsize-1,u8Xpos+u8Xsize-1,u8Ypos,u8Ypos+u8Ysize-1,u8SquareColorHB,u8SquareColorLB);  
  colorArea(u8Xpos,u8Xpos+u8Xsize-1,u8Ypos,u8Ypos,u8SquareColorHB,u8SquareColorLB);
  colorArea(u8Xpos,u8Xpos+u8Xsize-1,u8Ypos+u8Ysize-1,u8Ypos+u8Ysize-1,u8SquareColorHB,u8SquareColorLB);   
 
}
 
/*****************************************************************************/
/*                            Timer Array Update
/*****************************************************************************/

void vfnUpdate(UINT8 u8Data, UINT8 u8Index, UINT8 u8Action){
  
  if(u8Index<3){
    u8Index--;
    Display_Number(u8Data,MINUTE_POSITION+(u8Index*12),1);
    if(u8Action==SELECT)
      vfnDrawSelectedSquare(MINUTE_POSITION+(u8Index*12),20,11);
  }else{
    u8Index-=3;
    Display_Number(u8Data,SECOND_POSITION+(u8Index*12),1);
    if(u8Action==SELECT)
      vfnDrawSelectedSquare(SECOND_POSITION+(u8Index*12),20,11);
  }

}

/*****************************************************************************/
/*                           Timer Count Down Routine
/*****************************************************************************/

void vfnStartCountDown (UINT8 u8MinuteCount, UINT8 u8SecondCount){
  
  UINT8 u8dSecondCount=0;  
  UINT8 u8TimerOnOff=0, u8AlarmActive=False;
  
  /* SET CONFIGURED TIME */
  Display_Number(u8dSecondCount, DSECOND_POSITION, 2);
  Display_Number(u8SecondCount, SECOND_POSITION, 2);
  Display_Number(u8MinuteCount, MINUTE_POSITION, 2);
  
  /* Periodical TIMER Task until Exit */
  while(gu8ButtonStatus!=BUTTON_EXIT){
  
    TSS_Task();  // Touch Sensing Periodical task
    
    /* HOLD/RESTART TIMER */  
    if(gu8ButtonStatus == BUTTON_SELECT){
      u8TimerOnOff=~u8TimerOnOff;
     
      /* Flag in TIMER2 ON */
      if(u8TimerOnOff)
        TIME_TRACK_ENABLE=ON;
     
      /* Flag in TIMER2 OFF */
      if(!u8TimerOnOff)
        TIME_TRACK_ENABLE=OFF;
     
      /* TURN COUNTING ROUTINE FLAG OFF */
      gu8TPM1_CH0_IRQ=0;
     
      /* DEBOUNCE */
      gu8ButtonStatus=BUTTON_IDDLE;
    }
    
    /* COUNTING ROUTINE 1ms */
    if(gu8TPM1_CH0_IRQ){
    
      /* TURN COUNTING ROUTINE FLAG OFF, LATER TURNED ON IN TIMER2 ISR */
      gu8TPM1_CH0_IRQ=False;     
      
      u8dSecondCount--;   // Decrement a Tenth of a Second
          
      /* SECOND HAS ELAPSED */
      if(u8dSecondCount>99){
        u8dSecondCount=99;
        u8SecondCount--;
        
        /* MINUTE HAS ELAPSED */
        if(u8SecondCount>59){
          u8SecondCount=59;
          u8MinuteCount--;
          
          /* MAX MINUTES HAVE ELAPSED */
          if(u8MinuteCount>99){
            u8MinuteCount=0;
            u8SecondCount=0;
            u8dSecondCount=0;
            u8AlarmActive=True;
            gu8ButtonStatus=BUTTON_EXIT;          
          
          } 
          Display_Number(u8MinuteCount, MINUTE_POSITION, 2); // PRINT MINUTES
        
        }      
        Display_Number(u8SecondCount, SECOND_POSITION, 2);   // PRINT SECONDS
      
      }
     Display_Number(u8dSecondCount, DSECOND_POSITION, 2);    // PRINT TENTHS OF A SECOND
    
    }
    
  }

}